<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $post;
?>
<div class="reply-message-form-wrapper">
	<form id="reply-message-form" class="reply-message-form" action="?" method="post">
        
        <div class="wrapper-form">
            <?php
            if ( wp_private_message_get_option('message_attachments') ) {
                $file_types = wp_private_message_get_option('attachments_file_types');
                $file_types = !empty($file_types) ? $file_types : array();
                
                $file_types_str = !empty($file_types) ? implode('|', $file_types) : '';
                ?>
                <div class="form-group upload-file-btn-wrapper">
                    <input type="file" name="attachments[]" data-file_types="<?php echo esc_attr($file_types_str); ?>" multiple="multiple">

                    <div class="label-can-drag">
                        <div class="form-group group-upload">
                            <div class="upload-file-btn" data-text="<?php echo esc_attr(sprintf(esc_html__('Upload File (%s)', 'freeio'), $file_types_str)); ?>">
                                <span class="text"><?php echo sprintf(esc_html__('Upload File (%s)', 'freeio'), $file_types_str); ?></span>
                            </div>
                        </div>
                    </div>
                </div><!-- /.form-group -->
            <?php } ?>
            <textarea class="form-control" name="message" placeholder="<?php esc_attr_e( 'Écrivez votre message...', 'freeio' ); ?>" required="required"></textarea>
            <button class="button btn btn-theme reply-message-btn"><i class="flaticon-send"></i></button>
        </div><!-- /.form-group -->
        <?php wp_nonce_field( 'wp-private-message-reply-message', 'wp-private-message-reply-message-nonce' ); ?>
      	<input type="hidden" name="parent" value="<?php echo esc_attr($parent); ?>">
      	<input type="hidden" name="action" value="wp_private_message_reply_message">
	</form>
</div>