<?php
/**
 * The template for displaying a single Event custom post type.
 * This file should be in your child theme's root folder.
 * Path: /wp-content/themes/freeio-child/single-event.php
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

get_header();

?>

<?php while ( have_posts() ) : the_post(); ?>

    <?php
        // Get author/seller information
        $author_id = get_the_author_meta('ID');
        $author_name = get_the_author();
        $author_profile_url = get_author_posts_url($author_id);

        // Get ACF custom fields
        $event_date = get_field('event_date');
        $location = get_field('location');
        $ticket_price = get_field('ticket_price');

        // --- WOOCOMMERCE INTEGRATION ---
        // 1. Set the ID of your generic "Event Ticket" product.
        $product_id = 11168; // <--- CHANGE THIS to your actual product ID.

        // 2. Create the custom "add to cart" URL.
        $add_to_cart_url = add_query_arg( array(
            'add-to-cart' => $product_id,
            'event_id' => get_the_ID(), // Pass the current event's ID
        ), wc_get_checkout_url() ); // Redirect directly to checkout
    ?>

    <!-- ============================
         TOP HEADER SECTION
    ============================== -->
    <section class="event-detail-header-wrapper">
        <div class="container">
            <div class="event-header-content">
                <h1 class="event-title"><?php the_title(); ?></h1>
                <div class="event-header-meta">
                    <span>By: <?php echo esc_html($author_name); ?></span>
                </div>
            </div>
        </div>
    </section>

    <!-- ============================
         MAIN CONTENT SECTION
    ============================== -->
    <section class="event-detail-main-content-wrapper">
        <div class="container">
            <div class="event-content-area">

                <!-- Left Column (Main Content) -->
                <div class="event-main-column">
                    <?php if ( has_post_thumbnail() ) : ?>
                        <div class="event-featured-image">
                            <?php the_post_thumbnail('large'); ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="entry-content">
                        <h2><?php esc_html_e('À propos de ce programme', 'freeio'); ?></h2>
                        <?php the_content(); ?>
                    </div>
                </div>

                <!-- Right Column (Sidebar) -->
                <div class="event-sidebar-column">

                    <!-- Price Box -->
                    <div class="widget-box event-price-box">
                        <div class="event-price">€ <?php echo esc_html($ticket_price); ?></div>
                        
                        <?php
                        // --- PERMISSION CHECK ---
                        // Only show the button if the user is logged in AND is a freelancer or employer.
                        if ( is_user_logged_in() && ( WP_Freeio_User::is_freelancer() || WP_Freeio_User::is_employer() ) ) :
                        ?>
                            <a href="<?php echo esc_url($add_to_cart_url); ?>" class="btn btn-theme btn-block buy-now-button"><?php esc_html_e('Achetez maintenant.', 'freeio'); ?></a>
                        <?php else : ?>
                            <p class="login-prompt"><?php esc_html_e('Veuillez vous connecter pour acheter.', 'freeio'); ?></p>
                        <?php endif; ?>

                    </div>

                    <!-- About the Seller Box -->
                    <div class="widget-box event-seller-box">
                        <h3><?php esc_html_e('About The Organizer', 'freeio'); ?></h3>
                        <div class="seller-info">
                            <div class="seller-avatar">
                                <?php echo get_avatar($author_id, 80); ?>
                            </div>
                            <div class="seller-name">
                                <?php echo esc_html($author_name); ?>
                            </div>
                        </div>
                        <a href="<?php echo esc_url($author_profile_url); ?>" class="btn btn-outline-theme btn-block contact-button"><?php esc_html_e('View Profile', 'freeio'); ?></a>
                    </div>

                </div>

            </div>
        </div>
    </section>

<?php endwhile; ?>

<?php get_footer(); ?>
