<?php

/**
 * Enqueue child theme stylesheet.
 */
function freeio_child_enqueue_styles() {
    wp_enqueue_style( 'freeio-child-style', get_stylesheet_uri() );
}
add_action( 'wp_enqueue_scripts', 'freeio_child_enqueue_styles', 200 );

/**
add_action( 'pre_get_posts', 'freeio_custom_default_project_filter' );
function freeio_custom_default_project_filter( $query ) {
    $target_page_id = 8423;

    if ( ! is_admin() && ! $query->is_main_query() && is_page( $target_page_id ) && $query->get('post_type') === 'project' ) {


        $has_filter = false;
        $possible_filters = ['filter-category', 'filter_project_category', 'category', 'project_category'];

        foreach ( $possible_filters as $param ) {
            if ( isset( $_GET[$param] ) && ! empty( $_GET[$param] ) ) {
                $has_filter = true;
                break;
            }
        }

        if ( ! $has_filter ) {
            $parent_category_id = 167;
            $child_term_ids = get_term_children( $parent_category_id, 'project_category' );

            if ( ! empty( $child_term_ids ) && ! is_wp_error( $child_term_ids ) ) {
                $tax_query = array(
                    array(
                        'taxonomy' => 'project_category',
                        'field'    => 'term_id',
                        'terms'    => $child_term_ids,
                        'include_children' => false,
                    ),
                );
            } else {
                $tax_query = array(
                    array(
                        'taxonomy' => 'project_category',
                        'field'    => 'term_id',
                        'terms'    => array( $parent_category_id ),
                        'include_children' => true,
                    ),
                );
            }

            $query->set( 'tax_query', $tax_query );
        }
    }
}



add_filter( 'get_terms', 'freeio_custom_filter_only_subcategories', 10, 4 );
function freeio_custom_filter_only_subcategories( $terms, $taxonomies, $args, $term_query ) {

    if ( is_admin() || ! in_array( 'project_category', $taxonomies ) ) {
        return $terms;
    }


    $parent_category_id = 167;


    $child_term_ids = get_term_children( $parent_category_id, 'project_category' );


    $filtered_terms = array_filter( $terms, function ( $term ) use ( $child_term_ids ) {
        return in_array( $term->term_id, $child_term_ids );
    });

    return $filtered_terms;
}
**/

add_action( 'pre_get_posts', 'freeio_exclude_service_category_from_query' );
function freeio_exclude_service_category_from_query( $query ) {

    if ( is_admin() || ! is_page( 5146 ) ) {
        return;
    }


    if ( $query->get('post_type') === 'service' ) {
        $category_slug_to_exclude = 'holistic';


        $tax_query = $query->get('tax_query');
        if ( ! is_array($tax_query) ) {
            $tax_query = array();
        }

        $tax_query[] = array(
            'taxonomy' => 'service_category',
            'field'    => 'slug',
            'terms'    => array( $category_slug_to_exclude ),
            'operator' => 'NOT IN',
        );

        $query->set( 'tax_query', $tax_query );
    }
}



add_filter( 'get_terms', 'freeio_exclude_holistic_from_terms_list', 10, 3 );
function freeio_exclude_holistic_from_terms_list( $terms, $taxonomies, $args ) {

    if ( ! is_page( 5146 ) || ! in_array( 'service_category', $taxonomies ) ) {
        return $terms;
    }

    $category_id_to_exclude = 173; 

    foreach ( $terms as $key => $term ) {
        if ( is_object($term) && $term->term_id == $category_id_to_exclude ) {
            unset( $terms[$key] );
        }
    }

    return $terms;
}
add_action( 'pre_get_posts', 'freeio_display_specific_service_category' );
function freeio_display_specific_service_category( $query ) {


    $target_page_id = 5143; 
    $category_slug_to_display = 'holistic'; 

    if ( ! is_admin() && ! $query->is_main_query() && is_page( $target_page_id ) && $query->get('post_type') === 'service' ) {

        $tax_query = array(
            array(
                'taxonomy' => 'service_category',
                'field'    => 'slug',
                'terms'    => $category_slug_to_display,
                'include_children' => true, 
            ),
        );

        $query->set( 'tax_query', $tax_query );
    }
}
add_filter('gettext', function($translated, $text, $domain) {
    if ($domain === 'wp-freeio' && $text === 'Please wait you are redirecting to the checkout page.') {
        return 'Veuillez patienter, vous êtes redirigé vers la page de paiement.';
    }
	if ($domain === 'wp-freeio' && $text === 'You do not have permission to buy this service.') {
        return 'Vous n\'avez pas la permission d\'acheter ce service.';
    }
	if ($domain === 'wp-freeio' && $text === 'You are not allowed to send  the proposals.') {
        return 'Vous n\'êtes pas autorisé à envoyer les propositions.';
    }
	if ($domain === 'wp-freeio' && $text === 'Your proposal has sent Successfully') {
        return 'Votre proposition a été envoyée avec succès.';
    }
	if ($domain === 'wp-freeio' && $text === 'Proposal has been successfully removed.') {
        return 'La proposition a été supprimée avec succès.';
    }
	if ($domain === 'wp-freeio' && $text === 'Message is successful') {
        return 'Message bien supprimé';
    }
	if ($domain === 'wp-freeio' && $text === 'Service has been successfully removed.') {
        return 'Le service a été supprimé avec succès.';
    }
	if ($domain === 'wp-freeio' && $text === 'You do not have permission to buy this service. Please log in to continue.') {
        return 'Vous n\'avez pas la permission d\'acheter ce service. Veuillez vous connecter pour continuer.';
    }
    return $translated;
}, 10, 3);
/**
 * SOLUTION 1: Add JavaScript to the footer for client-side validation
 * of the Google Meet link on the service submission page.
 */
add_action( 'wp_footer', 'add_meet_link_validation_script' );

function add_meet_link_validation_script() {
    // Only run this script on the specific "Ajouter un service" page.
    // Replace 'submission-service' with the correct page slug if it's different.
    if ( is_page('submission-service') ) {
        ?>
        <script type="text/javascript">
            // Wait until the document is fully loaded
            document.addEventListener('DOMContentLoaded', function() {
                
                // Find the main form on the page
                const submissionForm = document.querySelector('form.cmb-form');

                if (submissionForm) {
                    submissionForm.addEventListener('submit', function(event) {
                        
                        // Find the Google Meet input field by its ID
                        const meetLinkInput = document.getElementById('googlemeetlink');
                        
                        if (meetLinkInput) {
                            const meetLinkValue = meetLinkInput.value.trim();
                            const requiredPrefix = 'https://meet.google.com/';

                            // If the field has a value but doesn't start with the correct prefix...
                            if (meetLinkValue && !meetLinkValue.startsWith(requiredPrefix)) {
                                
                                // Prevent the form from submitting
                                event.preventDefault();
                                
                                // Show an alert message to the user
                                alert('Erreur : Le champ "Lien Google Meet" doit contenir un lien valide qui commence par https://meet.google.com/');
                                
                                // Optional: Scroll to the field and focus on it
                                meetLinkInput.scrollIntoView({ behavior: 'smooth', block: 'center' });
                                meetLinkInput.focus();
                            }
                        }
                    });
                }
            });
        </script>
        <?php
    }
}
function freeio_render_amelia_from_custom_field() {
    
    // First, check if the user is logged in.
    if ( is_user_logged_in() ) {
        
        // --- User is logged in, show the booking form ---
        $post_id = get_the_ID();
        if ( !$post_id ) {
            return '';
        }

        // Get the value from our custom field 'ameliashortcode'
        $field_value = get_post_meta( $post_id, 'ameliashortcode', true );

        if ( ! empty( $field_value ) ) {
            // Clean up the value
            $field_value = trim( $field_value );

            // CASE 1: The user entered just a NUMBER (e.g. "1")
            if ( is_numeric( $field_value ) ) {
                // Automatically construct the standard booking shortcode
                // You can change 'ameliabooking' to 'ameliacatalogbooking' if you prefer the catalog style
                return do_shortcode( '[ameliacatalogbooking employee=' . $field_value . ']' );
            }
            
            // CASE 2: The user entered a FULL SHORTCODE (e.g. "[ameliabooking...]")
            elseif ( strpos( $field_value, '[' ) === 0 ) {
                // Use the shortcode exactly as typed
                return do_shortcode( $field_value );
            }
        }

        return '';

    } else {
        
        // --- User is a guest, show a login message ---
        
        // Get the current page URL to redirect them back here after login.
        $current_page_url = get_permalink( get_the_ID() );
        
        // Use the custom URLs provided by the user and add the redirect parameter
        $login_url = add_query_arg( 'redirect_to', urlencode( $current_page_url ), 'https://www.holistic-babe.fr/login/' );
        $register_url = 'https://www.holistic-babe.fr/register/';


        // Create the message (in French, as per previous translations)
        $message = '<div class="amelia-login-required" style="padding: 30px; border: 1px solid #e9e9e9; border-radius: 8px; text-align: center;">';
        $message .= '<h4 style="margin-top: 0; margin-bottom: 15px;">' . esc_html__('Connexion requise', 'freeio') . '</h4>';
        $message .= '<p style="margin-bottom: 20px;">' . esc_html__('Vous devez être connecté pour réserver cette session.', 'freeio') . '</p>';
        $message .= '<a href="' . esc_url($login_url) . '" class="btn btn-theme" style="margin-right: 10px;">' . esc_html__('Se connecter', 'freeio') . '</a>';
        
        if ( $register_url ) {
             $message .= '<a href="' . esc_url($register_url) . '" class="btn btn-theme-light">' . esc_html__('S\'inscrire', 'freeio') . '</a>';
        }
       
        $message .= '</div>';
        
        return $message;
    }
}
// We register our new function with the shortcode tag you suggested.
add_shortcode( 'amelia_show_field', 'freeio_render_amelia_from_custom_field' );
add_action('wp_footer', 'add_conditional_price_field_script', 999); // Use a very late priority

function add_conditional_price_field_script() {
?>
    <script type="text/javascript">
        (function($) {
            'use strict';
            
            $(document).ready(function() {
                
                // --- Price Field Toggling Logic ---

                var priceTypeDropdown = $('#_service_price_type');
                
                // Find the field's parent wrapper. This is more reliable.
                var priceFieldWrapper = $('#_service_price').closest('.form-group, .cmb-row');
                var packageFieldWrapper = $('#_service_price_packages').closest('.form-group, .cmb-row');
                
                // CORRECTED: Find the Google Meet field using the ID from your screenshot ('googlemeetlink')
                var googleMeetFieldWrapper = $('#googlemeetlink').closest('.form-group, .cmb-row');
				var durationWrapper = $('#_service_delivery_time').closest('.form-group, .cmb-row');


                // This function will show/hide the correct fields
                function togglePriceFields() {
                    if ( !priceTypeDropdown.length ) {
                        return; // Do nothing if the dropdown isn't on this page
                    }

                    // Get the value and trim whitespace, convert to lowercase
                    var selectedType = priceTypeDropdown.val().trim().toLowerCase();

                    // FIXED LOGIC: Check for 'appointment' and 'package'
                    if (selectedType === 'appointment') {
                        // User chose "Rendez-vous" (value is 'appointment')
                        priceFieldWrapper.hide();
                        packageFieldWrapper.hide();
                        googleMeetFieldWrapper.hide(); // Hide Google Meet field
						durationWrapper.hide();

                    } else if (selectedType === 'package') {
                        // User chose "Pack" (value is 'package')
                        priceFieldWrapper.hide();
                        packageFieldWrapper.show();
                        googleMeetFieldWrapper.show(); // Show Google Meet field
						durationWrapper.show();
                        
                    } else {
                        // Default (value is 'price')
                        priceFieldWrapper.show();
                        packageFieldWrapper.hide();
                        googleMeetFieldWrapper.show(); // Show Google Meet field
						durationWrapper.show();
                    }
                }
                
                // Run the function as soon as the page loads
                togglePriceFields();

                // Add an event listener to run the function every time the dropdown is changed
                priceTypeDropdown.on('change', function() {
                    togglePriceFields();
                });

            });
        })(jQuery);
    </script>
<?php
}
